/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multiview;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.core.multiview.ContextAwareDescription;
import org.netbeans.core.multiview.EditorsAction;
import org.netbeans.core.multiview.MultiViewElementCallbackDelegate;
import org.netbeans.core.multiview.MultiViewHandlerDelegate;
import org.netbeans.core.multiview.MultiViewModel;
import org.netbeans.core.multiview.MultiViewPeer;
import org.netbeans.core.multiview.MultiViewTopComponent;
import org.netbeans.core.multiview.MultiViewTopComponentLookup;
import org.netbeans.core.multiview.SourceCheckDescription;
import org.netbeans.core.multiview.SpiAccessor;
import org.netbeans.core.multiview.SplitAction;
import org.netbeans.core.multiview.Splitable;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.netbeans.core.spi.multiview.MultiViewElementCallback;
import org.netbeans.core.spi.multiview.SourceViewMarker;
import org.openide.awt.UndoRedo;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public final class MultiViewCloneableTopComponent
extends CloneableTopComponent
implements MultiViewModel.ActionRequestObserverFactory,
CloneableEditorSupport.Pane,
Splitable {
    MultiViewPeer peer = new MultiViewPeer((TopComponent)this, this);

    public MultiViewCloneableTopComponent() {
        this.peer.initComponents();
        this.setFocusCycleRoot(false);
        this.setName("");
        this.associateLookup(this.peer.getLookup());
    }

    public <T extends Serializable & Lookup.Provider> void setMimeLookup(String string, T t) {
        this.peer.setMimeLookup(string, t);
    }

    public void setMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription) {
        this.peer.setMultiViewDescriptions(multiViewDescriptionArray, multiViewDescription);
    }

    public void setCloseOperationHandler(CloseOperationHandler closeOperationHandler) {
        this.peer.setCloseOperationHandler(closeOperationHandler);
    }

    private void setDeserializedMultiViewDescriptions(MultiViewDescription[] multiViewDescriptionArray, MultiViewDescription multiViewDescription, Map map) {
        this.peer.setDeserializedMultiViewDescriptions(-1, multiViewDescriptionArray, multiViewDescription, null, map);
    }

    MultiViewModel getModel() {
        return this.peer.getModel();
    }

    public Lookup getLookup() {
        this.peer.assignLookup((MultiViewTopComponentLookup)super.getLookup());
        return super.getLookup();
    }

    protected void componentClosed() {
        super.componentClosed();
        this.peer.peerComponentClosed();
    }

    protected void componentShowing() {
        super.componentShowing();
        this.peer.peerComponentShowing();
    }

    protected void componentHidden() {
        super.componentHidden();
        this.peer.peerComponentHidden();
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.peer.peerComponentDeactivated();
    }

    protected void componentActivated() {
        super.componentActivated();
        this.peer.peerComponentActivated();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.peer.peerComponentOpened();
    }

    public boolean requestFocusInWindow() {
        return this.peer.requestFocusInWindow();
    }

    public void requestFocus() {
        this.peer.requestFocus();
    }

    public Action[] getActions() {
        Action[] actionArray = super.getActions();
        Action[] actionArray2 = this.peer.peerGetActions(actionArray);
        Action[] actionArray3 = new Action[actionArray2.length + 3];
        System.arraycopy(actionArray2, 0, actionArray3, 0, actionArray2.length);
        actionArray3[actionArray2.length + 1] = new EditorsAction();
        actionArray3[actionArray2.length + 2] = new SplitAction(true);
        return actionArray3;
    }

    public MultiViewHandlerDelegate getMultiViewHandlerDelegate() {
        return this.peer.getMultiViewHandlerDelegate();
    }

    public int getPersistenceType() {
        return this.peer.getPersistenceType();
    }

    protected String preferredID() {
        return this.peer.preferredID();
    }

    protected CloneableTopComponent createClonedObject() {
        MultiViewCloneableTopComponent multiViewCloneableTopComponent = new MultiViewCloneableTopComponent();
        multiViewCloneableTopComponent.setMultiViewDescriptions(this.peer.model.getDescriptions(), this.getActiveDescription());
        multiViewCloneableTopComponent.setCloseOperationHandler(this.peer.closeHandler);
        multiViewCloneableTopComponent.peer.copyMimeContext(this.peer);
        if (this.getSplitOrientation() != -1) {
            multiViewCloneableTopComponent.splitComponent(this.getSplitOrientation(), -1);
            multiViewCloneableTopComponent.updateName();
        }
        return multiViewCloneableTopComponent;
    }

    private MultiViewDescription getActiveDescription() {
        int n = this.getSplitOrientation();
        MultiViewDescription multiViewDescription = this.peer.model.getActiveDescription();
        if (n != -1) {
            boolean bl = false;
            if (multiViewDescription instanceof ContextAwareDescription) {
                bl = ((ContextAwareDescription)multiViewDescription).isSplitDescription();
            }
            if (bl) {
                for (MultiViewDescription multiViewDescription2 : this.peer.model.getDescriptions()) {
                    if (!multiViewDescription2.getDisplayName().equals(multiViewDescription.getDisplayName())) continue;
                    multiViewDescription = multiViewDescription2;
                    break;
                }
            }
        }
        return multiViewDescription;
    }

    @Override
    public TopComponent splitComponent(int n, int n2) {
        this.peer.peerSplitComponent(n, n2);
        return this;
    }

    @Override
    public TopComponent clearSplit(int n) {
        this.peer.peerClearSplit(n);
        return this;
    }

    @Override
    public int getSplitOrientation() {
        return this.peer.getSplitOrientation();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        this.peer.peerWriteExternal(objectOutput);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.peer.peerReadExternal(objectInput);
    }

    Action[] getDefaultTCActions() {
        return super.getActions();
    }

    @Override
    public MultiViewElementCallback createElementCallback(MultiViewDescription multiViewDescription) {
        return SpiAccessor.DEFAULT.createCallback(new ActReqObserver(multiViewDescription));
    }

    public CloneableTopComponent getComponent() {
        return this;
    }

    public JEditorPane getEditorPane() {
        if (this.peer == null || this.peer.model == null) {
            return null;
        }
        MultiViewElement multiViewElement = this.findPaneElement();
        if (multiViewElement != null) {
            CloneableEditorSupport.Pane pane = (CloneableEditorSupport.Pane)multiViewElement.getVisualRepresentation();
            return pane.getEditorPane();
        }
        return null;
    }

    private MultiViewElement findPaneElement() {
        MultiViewDescription[] multiViewDescriptionArray;
        MultiViewElement multiViewElement2 = this.peer.model.getActiveElement(false);
        if (multiViewElement2 != null && multiViewElement2.getVisualRepresentation() instanceof CloneableEditorSupport.Pane) {
            return multiViewElement2;
        }
        Collection collection = this.peer.model.getCreatedElements();
        for (MultiViewElement multiViewElement2 : collection) {
            if (!(multiViewElement2.getVisualRepresentation() instanceof CloneableEditorSupport.Pane)) continue;
            return multiViewElement2;
        }
        for (MultiViewDescription multiViewDescription : multiViewDescriptionArray = this.peer.model.getDescriptions()) {
            if (!MultiViewCloneableTopComponent.isSourceView(multiViewDescription)) continue;
            multiViewElement2 = this.peer.model.getElementForDescription(multiViewDescription);
            if (multiViewElement2.getVisualRepresentation() instanceof CloneableEditorSupport.Pane) {
                return multiViewElement2;
            }
            Logger.getLogger(this.getClass().getName()).info("MultiViewDescription " + multiViewDescription.getDisplayName() + "(" + multiViewDescription.getClass() + ") claimed to contain sources, but it's MutliViewElement.getVisualRepresentation() didn't return a valid CloeanbleEditorSupport.Pane instance.");
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return this.peer.getHelpCtx();
    }

    public String toString() {
        return "MVCTC[name=" + this.getDisplayName() + ", peer=" + this.peer + "]";
    }

    public UndoRedo getUndoRedo() {
        UndoRedo undoRedo = this.peer.peerGetUndoRedo();
        if (undoRedo == null) {
            undoRedo = super.getUndoRedo();
        }
        return undoRedo;
    }

    protected boolean closeLast() {
        return this.peer.canClose();
    }

    public void updateName() {
        if (this.peer != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.peer.updateName();
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MultiViewCloneableTopComponent.this.peer.updateName();
                    }
                });
            }
        }
    }

    public void ensureVisible() {
        MultiViewElement multiViewElement = this.findPaneElement();
        if (multiViewElement != null) {
            this.open();
            MultiViewElementCallback multiViewElementCallback = this.peer.getModel().getCallbackForElement(multiViewElement);
            multiViewElementCallback.requestVisible();
        }
    }

    static boolean isSourceView(MultiViewDescription multiViewDescription) {
        if (multiViewDescription instanceof SourceViewMarker) {
            return true;
        }
        if (multiViewDescription instanceof SourceCheckDescription) {
            return ((SourceCheckDescription)multiViewDescription).isSourceView();
        }
        return false;
    }

    public TopComponent.SubComponent[] getSubComponents() {
        return MultiViewTopComponent.getSubComponents(this.peer);
    }

    class ActReqObserver
    implements Serializable,
    MultiViewElementCallbackDelegate {
        private static final long serialVersionUID = -3126744916624172415L;
        private MultiViewDescription description;

        ActReqObserver(MultiViewDescription multiViewDescription) {
            this.description = multiViewDescription;
        }

        @Override
        public void requestActive() {
            boolean bl = MultiViewCloneableTopComponent.this.peer.isActivated();
            if (!bl) {
                MultiViewCloneableTopComponent.this.requestActive();
            }
            if (MultiViewCloneableTopComponent.this.peer.model.getActiveDescription() != this.description) {
                if (bl) {
                    MultiViewCloneableTopComponent.this.peer.model.getActiveElement().componentDeactivated();
                }
                MultiViewCloneableTopComponent.this.peer.tabs.changeActiveManually(this.description);
                if (bl) {
                    MultiViewCloneableTopComponent.this.peer.model.getActiveElement().componentActivated();
                }
            }
        }

        @Override
        public void requestVisible() {
            MultiViewCloneableTopComponent.this.peer.tabs.changeVisibleManually(this.description);
        }

        @Override
        public Action[] createDefaultActions() {
            return MultiViewCloneableTopComponent.this.getDefaultTCActions();
        }

        @Override
        public void updateTitle(String string) {
            MultiViewCloneableTopComponent.this.setDisplayName(string);
        }

        public Object writeReplace() throws ObjectStreamException {
            return null;
        }

        public Object readResolve() throws ObjectStreamException {
            return null;
        }

        @Override
        public boolean isSelectedElement() {
            return this.description.equals(MultiViewCloneableTopComponent.this.peer.model.getActiveDescription());
        }

        @Override
        public TopComponent getTopComponent() {
            return MultiViewCloneableTopComponent.this;
        }
    }
}

