/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal.inst;

import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketOptions;
import jdk.internal.instrumentation.InstrumentationMethod;
import jdk.internal.instrumentation.InstrumentationTarget;
import jdk.internal.instrumentation.TypeMapping;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceRequestDeniedException;
import jdk.management.resource.internal.ApproverGroup;
import jdk.management.resource.internal.ResourceIdImpl;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

@InstrumentationTarget(value="java.net.Socket")
@TypeMapping(from="jdk.management.resource.internal.inst.SocketRMHooks$SocketImpl", to="java.net.SocketImpl")
public final class SocketRMHooks {
    private boolean created = false;
    SocketImpl impl;

    public InetAddress getLocalAddress() {
        return this.getLocalAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void bind(SocketAddress socketAddress) throws IOException {
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (!this.isBound()) {
            resourceIdImpl = ResourceIdImpl.of(socketAddress);
            resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new IOException("Resource limited: too many open sockets");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many open sockets", resourceRequestDeniedException);
            }
        }
        int n = 0;
        try {
            this.bind(socketAddress);
            n = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n), resourceIdImpl);
            }
        }
    }

    @InstrumentationMethod
    public boolean isBound() {
        return this.isBound();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public void connect(SocketAddress socketAddress, int n) throws IOException {
        ResourceIdImpl resourceIdImpl = null;
        ResourceRequest resourceRequest = null;
        long l = 0L;
        if (!this.isBound()) {
            resourceIdImpl = ResourceIdImpl.of(this.getLocalAddress());
            resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
            try {
                l = resourceRequest.request(1L, resourceIdImpl);
                if (l < 1L) {
                    throw new IOException("Resource limited: too many open sockets");
                }
            }
            catch (ResourceRequestDeniedException resourceRequestDeniedException) {
                throw new IOException("Resource limited: too many open sockets", resourceRequestDeniedException);
            }
        }
        int n2 = 0;
        try {
            this.connect(socketAddress, n);
            n2 = 1;
        }
        finally {
            if (resourceRequest != null) {
                resourceRequest.request(-(l - (long)n2), resourceIdImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    final void postAccept() {
        long l;
        this.postAccept();
        FileDescriptor fileDescriptor = this.impl.getFileDescriptor();
        JavaIOFileDescriptorAccess javaIOFileDescriptorAccess = SharedSecrets.getJavaIOFileDescriptorAccess();
        try {
            l = javaIOFileDescriptorAccess.getHandle(fileDescriptor);
            if (l == -1L) {
                l = javaIOFileDescriptorAccess.get(fileDescriptor);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            l = javaIOFileDescriptorAccess.get(fileDescriptor);
        }
        ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(l);
        ResourceRequest resourceRequest = ApproverGroup.FILEDESCRIPTOR_OPEN_GROUP.getApprover(fileDescriptor);
        long l2 = 0L;
        boolean bl = false;
        try {
            l2 = resourceRequest.request(1L, resourceIdImpl);
            if (l2 < 1L) {
                throw new ResourceRequestDeniedException("Resource limited: too many open file descriptors");
            }
            bl = true;
        }
        finally {
            if (!bl) {
                try {
                    this.close();
                }
                catch (IOException iOException) {}
                resourceRequest.request(-Math.max(0L, l2 - 1L), resourceIdImpl);
            }
        }
    }

    @InstrumentationMethod
    public boolean isClosed() {
        return this.isClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InstrumentationMethod
    public synchronized void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        boolean bl = this.isBound();
        InetAddress inetAddress = this.getLocalAddress();
        try {
            this.close();
        }
        finally {
            if (bl) {
                ResourceIdImpl resourceIdImpl = ResourceIdImpl.of(inetAddress);
                ResourceRequest resourceRequest = ApproverGroup.SOCKET_OPEN_GROUP.getApprover(this);
                resourceRequest.request(-1L, resourceIdImpl);
            }
        }
    }

    abstract class SocketImpl
    implements SocketOptions {
        protected FileDescriptor fd;

        SocketImpl() {
        }

        protected FileDescriptor getFileDescriptor() {
            return this.fd;
        }
    }
}

