/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.common;

import java.util.Map;
import org.netbeans.lib.profiler.ProfilerEngineSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;

public final class AttachSettings {
    public static final String PROP_ATTACH_DIRECT = "profiler.attach.direct";
    public static final String PROP_ATTACH_REMOTE = "profiler.attach.remote";
    public static final String PROP_ATTACH_DYNAMIC_JDK16 = "profiler.attach.dynamic.jdk16";
    public static final String PROP_ATTACH_HOST = "profiler.attach.host";
    public static final String PROP_ATTACH_PORT = "profiler.attach.port";
    public static final String PROP_ATTACH_TARGET_TYPE = "profiler.attach.target.type";
    public static final String PROP_ATTACH_SERVER_TYPE = "profiler.attach.server.type";
    public static final String PROP_ATTACH_HOST_OS = "profiler.attach.host.os";
    private String host = "";
    private String hostOS;
    private String hostOS_dbl = this.hostOS = "";
    private String host_dbl = this.host;
    private String remoteHostOS = "";
    private String serverType;
    private String serverType_dbl = this.serverType = "";
    private String targetType;
    private String targetType_dbl = this.targetType = "";
    private boolean direct = true;
    private boolean direct_dbl = this.direct = true;
    private boolean dynamic16;
    private boolean dynamic16_dbl = this.dynamic16 = false;
    private boolean remote = false;
    private boolean remote_dbl = this.remote = false;
    private int pid;
    private int pid_dbl = this.pid = -1;
    private int transientPort;
    private int transientPort_dbl = this.transientPort = -1;

    public AttachSettings() {
        this.hostOS = IntegrationUtils.getLocalPlatform(-1);
    }

    public void setDirect(boolean bl) {
        this.direct = bl;
    }

    public boolean isDirect() {
        return this.direct;
    }

    public void setDynamic16(boolean bl) {
        this.dynamic16 = bl;
    }

    public boolean isDynamic16() {
        return this.dynamic16;
    }

    public void setHost(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        this.host = string;
    }

    public String getHost() {
        return this.host;
    }

    public void setHostOS(String string) {
        this.hostOS = string != null ? string : (this.remote ? this.remoteHostOS : IntegrationUtils.getLocalPlatform(-1));
    }

    public String getHostOS() {
        return this.hostOS;
    }

    public void setPid(int n) {
        this.pid = n;
    }

    public int getPid() {
        return this.pid;
    }

    public void setPort(int n) {
        this.transientPort = n;
    }

    public int getPort() {
        if (this.transientPort != -1) {
            return this.transientPort;
        }
        return Profiler.getDefault().getGlobalProfilingSettings().getPortNo();
    }

    public void setRemote(boolean bl) {
        this.remote = bl;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void setServerType(String string) {
        this.serverType = string;
    }

    public String getServerType() {
        return this.serverType;
    }

    public void setTargetType(String string) {
        this.targetType = string;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void applySettings(ProfilerEngineSettings profilerEngineSettings) {
        profilerEngineSettings.setPortNo(this.getPort());
        if (this.remote) {
            profilerEngineSettings.setRemoteHost(this.host);
        } else {
            profilerEngineSettings.setRemoteHost("");
        }
    }

    public boolean commit() {
        boolean bl = false;
        if (this.direct != this.direct_dbl) {
            bl = true;
            this.direct_dbl = this.direct;
        }
        if (this.remote != this.remote_dbl) {
            bl = true;
            this.remote_dbl = this.remote;
        }
        if (this.dynamic16 != this.dynamic16_dbl) {
            bl = true;
            this.dynamic16_dbl = this.dynamic16;
        }
        if (this.host_dbl == null || !this.host.equalsIgnoreCase(this.host_dbl)) {
            bl = true;
            this.host_dbl = this.host;
        }
        if (this.transientPort_dbl != this.transientPort) {
            bl = true;
            this.transientPort_dbl = this.transientPort;
        }
        if (this.targetType_dbl == null || !this.targetType.equalsIgnoreCase(this.targetType_dbl)) {
            bl = true;
            this.targetType_dbl = this.targetType;
        }
        if (this.serverType_dbl == null || !this.serverType.equalsIgnoreCase(this.serverType_dbl)) {
            bl = true;
            this.serverType_dbl = this.serverType;
        }
        if (this.hostOS_dbl == null || !this.hostOS.equalsIgnoreCase(this.hostOS_dbl)) {
            bl = true;
            this.hostOS_dbl = this.hostOS;
        }
        return bl;
    }

    public void copyInto(AttachSettings attachSettings) {
        attachSettings.direct = this.direct;
        attachSettings.direct_dbl = this.direct_dbl;
        attachSettings.remote = this.remote;
        attachSettings.remote_dbl = this.remote_dbl;
        attachSettings.dynamic16 = this.dynamic16;
        attachSettings.dynamic16_dbl = this.dynamic16_dbl;
        attachSettings.pid = this.pid;
        attachSettings.pid_dbl = this.pid_dbl;
        attachSettings.host = this.host;
        attachSettings.host_dbl = this.host_dbl;
        attachSettings.targetType = this.targetType;
        attachSettings.targetType_dbl = this.targetType_dbl;
        attachSettings.serverType = this.serverType;
        attachSettings.serverType_dbl = this.serverType_dbl;
        attachSettings.hostOS = this.hostOS;
        attachSettings.hostOS_dbl = this.hostOS_dbl;
        attachSettings.remoteHostOS = this.remoteHostOS;
    }

    public String debug() {
        return this.toString();
    }

    public void load(Map map) {
        this.direct = Boolean.valueOf(ProfilingSettings.getProperty(map, PROP_ATTACH_DIRECT, "true"));
        this.remote = Boolean.valueOf(ProfilingSettings.getProperty(map, PROP_ATTACH_REMOTE, "false"));
        this.dynamic16 = Boolean.valueOf(ProfilingSettings.getProperty(map, PROP_ATTACH_DYNAMIC_JDK16, "false"));
        this.host = ProfilingSettings.getProperty(map, PROP_ATTACH_HOST, "");
        this.targetType = ProfilingSettings.getProperty(map, PROP_ATTACH_TARGET_TYPE, "");
        this.serverType = ProfilingSettings.getProperty(map, PROP_ATTACH_SERVER_TYPE, "");
        this.remoteHostOS = ProfilingSettings.getProperty(map, PROP_ATTACH_HOST_OS, IntegrationUtils.getLocalPlatform(-1));
    }

    public void store(Map map) {
        map.put(PROP_ATTACH_DIRECT, Boolean.toString(this.direct));
        map.put(PROP_ATTACH_REMOTE, Boolean.toString(this.remote));
        map.put(PROP_ATTACH_DYNAMIC_JDK16, Boolean.toString(this.dynamic16));
        map.put(PROP_ATTACH_HOST, this.host);
        map.put(PROP_ATTACH_TARGET_TYPE, this.targetType);
        map.put(PROP_ATTACH_SERVER_TYPE, this.serverType);
        map.put(PROP_ATTACH_HOST_OS, this.hostOS);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("target type =").append(this.targetType);
        stringBuffer.append("\n");
        stringBuffer.append("server type =").append(this.serverType);
        stringBuffer.append("\n");
        stringBuffer.append("remote =").append(this.remote);
        stringBuffer.append("\n");
        stringBuffer.append("direct =").append(this.direct);
        stringBuffer.append("\n");
        stringBuffer.append("dynamic JDK16 =").append(this.dynamic16);
        stringBuffer.append("\n");
        stringBuffer.append("pid =").append(this.pid);
        stringBuffer.append("\n");
        stringBuffer.append("host =").append(this.host);
        stringBuffer.append("\n");
        stringBuffer.append("host os =").append(this.hostOS);
        stringBuffer.append("\n");
        stringBuffer.append("transient port =").append(this.transientPort);
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }
}

