/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.main.server;

import com.sun.deploy.config.Config;
import com.sun.deploy.util.SystemUtils;
import sun.plugin2.applet.Applet2ThreadGroup;
import sun.plugin2.applet.Plugin2Manager;
import sun.plugin2.util.SystemUtil;

public class JVMHealthData {
    static final long HEALTHY_AVAILABLE_HEAP_SIZE = 0x2000000L;
    static final int MAX_APPLET_THREAD_COUNT = Config.getMaxAppletThreadCount();
    private static final boolean DEBUG = SystemUtil.isDebug();
    private static final boolean NO_HEARTBEAT;
    private long maxHeapSize = -1L;
    private long heapSize = -1L;
    private long freeHeapSize = -1L;
    private int appletThreadCount = -1;
    private long launchMicroSeconds = -1L;

    public JVMHealthData() {
    }

    public JVMHealthData(long l, long l2, long l3, int n) {
        this.maxHeapSize = l;
        this.heapSize = l2;
        this.freeHeapSize = l3;
        this.appletThreadCount = n;
    }

    public static JVMHealthData getCurrent() {
        long l = Runtime.getRuntime().maxMemory();
        long l2 = Runtime.getRuntime().totalMemory();
        long l3 = Runtime.getRuntime().freeMemory();
        int n = Applet2ThreadGroup.getAppletThreadCount();
        JVMHealthData jVMHealthData = new JVMHealthData(l, l2, l3, n);
        long l4 = Plugin2Manager.getJVMLaunchTime();
        if (l4 <= 0L) {
            l4 = SystemUtils.microTime();
        }
        jVMHealthData.setLaunchMicroSeconds(l4);
        return jVMHealthData;
    }

    public long getFreeHeapSize() {
        return this.freeHeapSize;
    }

    public long getHeapSize() {
        return this.heapSize;
    }

    public long getMaxHeapSize() {
        return this.maxHeapSize;
    }

    public long getUsedHeapSize() {
        if (!this.validateMemoryData()) {
            return -1L;
        }
        return this.heapSize - this.freeHeapSize;
    }

    public long getAvailableHeapSize() {
        if (!this.validateMemoryData()) {
            return -1L;
        }
        return this.maxHeapSize - this.getUsedHeapSize();
    }

    public int getAppletThreadCount() {
        return this.appletThreadCount;
    }

    private boolean validateMemoryData() {
        return this.maxHeapSize >= 0L && this.heapSize >= 0L && this.freeHeapSize >= 0L;
    }

    public synchronized void updateFrom(JVMHealthData jVMHealthData) {
        this.maxHeapSize = jVMHealthData.getMaxHeapSize();
        this.heapSize = jVMHealthData.getHeapSize();
        this.freeHeapSize = jVMHealthData.getFreeHeapSize();
        this.appletThreadCount = jVMHealthData.getAppletThreadCount();
    }

    public synchronized boolean isHealthy() {
        if (NO_HEARTBEAT) {
            return true;
        }
        if (!this.beenLaunched()) {
            return false;
        }
        if (this.getMaxHeapSize() < 0L && this.currentAgeSeconds() < 5L) {
            return true;
        }
        return this.getMaxHeapSize() > 0L && this.getAvailableHeapSize() >= 0x2000000L && this.getAppletThreadCount() < MAX_APPLET_THREAD_COUNT;
    }

    void setLaunchMicroSeconds(long l) {
        this.launchMicroSeconds = l;
    }

    private boolean beenLaunched() {
        return this.launchMicroSeconds > 0L;
    }

    public long currentAgeSeconds() {
        if (this.launchMicroSeconds == 0L) {
            return 0L;
        }
        return (SystemUtils.microTime() - this.launchMicroSeconds) / 1000000L;
    }

    public String toString() {
        return new StringBuffer().append("{ healthy: ").append(this.isHealthy()).append(", ageSeconds: ").append(this.currentAgeSeconds()).append(", availableHeapKB: ").append(this.getAvailableHeapSize() / 1024L).append(", appletThreads: ").append(this.getAppletThreadCount()).append(" }").toString();
    }

    static {
        boolean bl = NO_HEARTBEAT = SystemUtil.getenv("JPI_PLUGIN2_NO_HEARTBEAT") != null;
        if (DEBUG && NO_HEARTBEAT) {
            System.out.println("JPI_PLUGIN2_NO_HEARTBEAT is set, all health data are assumed normal.");
        }
    }
}

