/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder;

import com.jrockit.mc.common.IMCFrame;
import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.IMCStackTrace;
import com.jrockit.mc.common.IMCType;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.FlightRecordingLoader;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IField;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Date;

public final class RecordingPrinter {
    private Verbosity m_verbosity = Verbosity.HIGH;
    private TimeFormat m_timeFormat;
    private final PrintWriter m_out;
    private final FlightRecording m_recording;
    private final DateFormat DATE_FORMATTER = DateFormat.getDateInstance();
    private final DateFormat TIME_FORMATTER = DateFormat.getTimeInstance();
    private static NumberFormat TIMESPAN_FORMATTER = NumberFormat.getInstance();

    public RecordingPrinter(PrintWriter output, FlightRecording recording) {
        TIMESPAN_FORMATTER.setMinimumFractionDigits(3);
        TIMESPAN_FORMATTER.setMaximumFractionDigits(3);
        this.m_out = output;
        this.m_recording = recording;
    }

    public void setTimeFormat(TimeFormat timeFormat) {
        this.m_timeFormat = timeFormat;
    }

    public void setVerbosityLevel(Verbosity verbosity) {
        this.m_verbosity = verbosity;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        if (args.length > 0) {
            try {
                FlightRecording recording = FlightRecordingLoader.loadFile(new File(args[args.length - 1], "r"));
                RecordingPrinter printer = new RecordingPrinter(new PrintWriter(System.out), recording);
                printer.setOptions(args);
                printer.print();
                return;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        RecordingPrinter.printHelp();
    }

    public void print() {
        this.m_out.println("<?xml version=\"1.0\"?>");
        for (IEvent iEvent : this.m_recording.createView()) {
            RecordingPrinter.printEvent(iEvent, this.m_verbosity, this.m_out);
            this.m_out.println();
        }
        this.m_out.flush();
    }

    void setOptions(String[] args) throws ParseException {
        int n = 0;
        while (n < args.length - 1) {
            if (args[n].equals("-humanTime")) {
                this.m_timeFormat = TimeFormat.HUMAN_READABLE;
            } else if (args[n].equals("-brief")) {
                this.m_verbosity = Verbosity.LOW;
            } else {
                throw new ParseException("Unknown command " + args[n], n);
            }
            ++n;
        }
    }

    private static void printHelp() {
        System.out.println("Usage:");
        System.out.println("filename The name of the flight recording file to print.");
    }

    public static void printEvent(IEvent e, Verbosity verbosity, PrintWriter out) {
        out.println("<event name=\"" + e.getEventType().getName() + "\" path=\"" + e.getEventType().getPath() + "\" jvmId=\"" + e.getEventType().getId() + "\">");
        if (verbosity == Verbosity.HIGH) {
            RecordingPrinter.printValues(e, verbosity, out);
        }
        out.print("</event>");
    }

    private static void printValues(IEvent event, Verbosity verbosity, PrintWriter out) {
        for (IField field : event.getEventType().getFields()) {
            if (!field.isVisible() || field.isSynthetic()) continue;
            RecordingPrinter.printValue(field, field.getValue(event), verbosity, out);
        }
    }

    private static void printValue(IField field, Object value, Verbosity verbosity, PrintWriter out) {
        if (value instanceof IMCStackTrace) {
            RecordingPrinter.printTrace((IMCStackTrace)value, verbosity, out);
        } else {
            out.print("  <" + field.getIdentifier() + " name=\"" + field.getName() + "\">");
            if (value == null) {
                out.print("null");
            } else {
                out.print(RecordingPrinter.stringify("", value));
            }
            out.println("</" + field.getIdentifier() + ">");
        }
    }

    private static String stringify(String indent, Object value) {
        if (value instanceof IMCMethod) {
            return String.valueOf(indent) + RecordingPrinter.stringifyMethod((IMCMethod)value);
        }
        if (value instanceof IMCType) {
            return String.valueOf(indent) + RecordingPrinter.stringifyType((IMCType)value);
        }
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            StringBuffer buffer = new StringBuffer();
            Object[] values = (Object[])value;
            buffer.append(" [" + values.length + "]");
            Object[] objectArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                buffer.append(indent);
                buffer.append(RecordingPrinter.stringify(String.valueOf(indent) + "  ", o));
                ++n2;
            }
            return buffer.toString();
        }
        return value.toString();
    }

    private static void printTrace(IMCStackTrace trace, Verbosity verbosity, PrintWriter out) {
        out.println("  <stackTrace>");
        if (verbosity == Verbosity.HIGH) {
            for (IMCFrame frame : trace.getFrames()) {
                RecordingPrinter.printFrame("     ", frame, out);
            }
        }
        out.println("  </stackTrace>");
    }

    private static void printFrame(String indent, IMCFrame frame, PrintWriter out) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(indent);
        buffer.append("<frame ");
        Integer lineNumber = frame.getFrameLineNumber();
        IMCMethod method = frame.getMethod();
        buffer.append("method=\"");
        if (method != null) {
            buffer.append(RecordingPrinter.stringify("", method));
        } else {
            buffer.append("null");
        }
        buffer.append(" line=\"");
        buffer.append(String.valueOf(lineNumber));
        buffer.append("\" type=\"" + frame.getType() + "\"/>");
        out.println(buffer.toString());
    }

    private static String stringifyType(IMCType type) {
        StringBuffer sb = new StringBuffer();
        String packageName = type.getPackageName();
        if (packageName == null) {
            sb.append("null");
        } else {
            sb.append(RecordingPrinter.formatPackageName(packageName));
        }
        sb.append(".");
        sb.append(String.valueOf(type.getTypeName()));
        return sb.toString();
    }

    private static String stringifyMethod(IMCMethod method) {
        StringBuffer buffer = new StringBuffer();
        Integer modifier = method.getModifier();
        buffer.append(RecordingPrinter.formatPackageName(method.getPackageName()));
        buffer.append(".");
        buffer.append(method.getClassName());
        buffer.append("#");
        buffer.append(method.getMethodName());
        buffer.append(method.getFormalDescriptor());
        buffer.append("\"");
        if (modifier != null) {
            buffer.append(" modifier=\"");
            buffer.append(Modifier.toString(method.getModifier()));
            buffer.append("\"");
        }
        return buffer.toString();
    }

    private static String formatPackageName(String packageName) {
        if (packageName.length() == 0) {
            return "(default package)";
        }
        return packageName;
    }

    String formatTimestamp(long timestamp) {
        if (this.m_timeFormat == TimeFormat.HUMAN_READABLE) {
            StringBuffer buffer = new StringBuffer();
            Date date = new Date(timestamp / 1000000L);
            buffer.append(this.TIME_FORMATTER.format(date));
            buffer.append(' ');
            buffer.append(this.DATE_FORMATTER.format(date));
            return buffer.toString();
        }
        return Long.toString(timestamp);
    }

    String formatTimespan(long timespan) {
        if (this.m_timeFormat == TimeFormat.HUMAN_READABLE) {
            return String.valueOf(Double.toString((double)timespan / 1.0E10)) + " s";
        }
        return Long.toString(timespan);
    }

    public static enum TimeFormat {
        NANOS("nanoTime"),
        HUMAN_READABLE("humanTime");

        private String m_switchName;

        private TimeFormat(String switchName) {
            this.m_switchName = switchName;
        }

        String getSwitchName() {
            return this.m_switchName;
        }
    }

    public static enum Verbosity {
        HIGH,
        MEDIUM,
        LOW;

    }
}

