/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;
import org.netbeans.lib.profiler.ui.UIConstants;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.components.JTreeTable;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelBracketTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.MethodNameTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.ExtendedTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.JTreeTablePanel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;
import org.netbeans.lib.profiler.ui.cpu.SnapshotCPUResultsPanel;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.api.icons.Icons;

public class SubtreeCallGraphPanel
extends SnapshotCPUResultsPanel
implements ScreenshotProvider {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.cpu.Bundle");
    private static final String PANEL_TITLE = messages.getString("SubtreeCallGraphPanel_PanelTitle");
    private static final String PANEL_TITLE_SHORT = messages.getString("SubtreeCallGraphPanel_PanelTitleShort");
    private static final String METHOD_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_MethodColumnName");
    private static final String METHOD_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_MethodColumnToolTip");
    private static final String METHOD_FILTER_HINT = messages.getString("FlatProfilePanel_MethodFilterHint");
    private static final String CLASS_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_ClassColumnName");
    private static final String CLASS_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_ClassColumnToolTip");
    private static final String CLASS_FILTER_HINT = messages.getString("FlatProfilePanel_ClassFilterHint");
    private static final String PACKAGE_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_PackageColumnName");
    private static final String PACKAGE_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_PackageColumnToolTip");
    private static final String PACKAGE_FILTER_HINT = messages.getString("FlatProfilePanel_PackageFilterHint");
    private static final String TIME_REL_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_TimeRelColumnName");
    private static final String TIME_REL_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_TimeRelColumnToolTip");
    private static final String TIME_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_TimeColumnName");
    private static final String TIME_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_TimeColumnToolTip");
    private static final String TIME_CPU_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_TimeCpuColumnName");
    private static final String TIME_CPU_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_TimeCpuColumnToolTip");
    private static final String INVOCATIONS_COLUMN_NAME = messages.getString("SubtreeCallGraphPanel_InvocationsColumnName");
    private static final String INVOCATIONS_COLUMN_TOOLTIP = messages.getString("SubtreeCallGraphPanel_InvocationsColumnToolTip");
    private static final String TREETABLE_ACCESS_NAME = messages.getString("SubtreeCallGraphPanel_TreeTableAccessName");
    private static final String FILTER_ITEM_NAME = messages.getString("FlatProfilePanel_FilterItemName");
    private static final String SAMPLES_COLUMN_NAME = messages.getString("CCTDisplay_SamplesColumnName");
    private static final String SAMPLES_COLUMN_TOOLTIP = messages.getString("CCTDisplay_SamplesColumnToolTip");
    protected JButton cornerButton;
    protected JTreeTable treeTable;
    protected JTreeTablePanel treeTablePanel;
    protected FilterComponent filterComponent;
    protected PrestimeCPUCCTNode rootNode = null;
    protected boolean sortOrder;
    protected int sortingColumn;
    private AbstractTreeTableModel abstractTreeTableModel;
    private EnhancedTreeCellRenderer enhancedTreeCellRenderer = new MethodNameTreeCellRenderer();
    private ExtendedTreeTableModel treeTableModel;
    private Icon leafIcon = Icons.getIcon((String)"ProfilerIcons.NodeLeaf");
    private Icon nodeIcon = Icons.getIcon((String)"ProfilerIcons.NodeForward");
    private int minNamesColumnWidth;

    public SubtreeCallGraphPanel(CPUResUserActionsHandler cPUResUserActionsHandler, Boolean bl) {
        super(cPUResUserActionsHandler, bl);
        this.enhancedTreeCellRenderer.setLeafIcon(this.leafIcon);
        this.enhancedTreeCellRenderer.setClosedIcon(this.nodeIcon);
        this.enhancedTreeCellRenderer.setOpenIcon(this.nodeIcon);
        this.minNamesColumnWidth = this.getFontMetrics(this.getFont()).charWidth('W') * 30;
        this.cornerPopup = new JPopupMenu();
        this.cornerButton = this.createHeaderPopupCornerButton(this.cornerPopup);
        this.setDefaultSorting();
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, String string) {
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setMinimumFractionDigits(2);
        PrestimeCPUCCTNodeBacked.setPercentFormat((NumberFormat)this.percentFormat);
        switch (n) {
            case 1: {
                exportDataDumper.dumpData((CharSequence)this.getCSVHeader(","));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportCSVData(",", n, exportDataDumper);
                exportDataDumper.close();
                break;
            }
            case 2: {
                exportDataDumper.dumpData((CharSequence)this.getCSVHeader(";"));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportCSVData(";", n, exportDataDumper);
                exportDataDumper.close();
                break;
            }
            case 3: {
                exportDataDumper.dumpData((CharSequence)this.getXMLHeader(string));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportXMLData(exportDataDumper, "  ");
                exportDataDumper.dumpDataAndClose(this.getXMLFooter());
                break;
            }
            case 4: {
                exportDataDumper.dumpData((CharSequence)this.getHTMLHeader(string));
                ((PrestimeCPUCCTNodeBacked)this.abstractTreeTableModel.getRoot()).exportHTMLData(exportDataDumper, 0);
                exportDataDumper.dumpDataAndClose(this.getHTMLFooter());
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    private StringBuffer getCSVHeader(String string) {
        String string2 = "\r\n";
        String string3 = "\"";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.columnCount; ++i) {
            stringBuffer.append(string3).append(this.columnNames[i]).append(string3).append(string);
        }
        stringBuffer.append(string2);
        return stringBuffer;
    }

    private StringBuffer getHTMLHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><table border=\"1\"><tr>");
        for (int i = 0; i < this.columnCount; ++i) {
            stringBuffer.append("<th>").append(this.columnNames[i]).append("</th>");
        }
        stringBuffer.append("</tr>");
        return stringBuffer;
    }

    private StringBuffer getHTMLFooter() {
        return new StringBuffer("</TABLE></BODY></HTML>");
    }

    private StringBuffer getXMLHeader(String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string2 + "<ExportedView Name=\"" + string + "\" type=\"tree\">" + string2 + "<tree>" + string2);
        return stringBuffer;
    }

    private StringBuffer getXMLFooter() {
        String string = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("</tree>" + string + "</ExportedView>");
        return stringBuffer;
    }

    @Override
    public int getCurrentThreadId() {
        return this.rootNode != null ? this.rootNode.getThreadId() : 0;
    }

    @Override
    public BufferedImage getCurrentViewScreenshot(boolean bl) {
        if (this.treeTablePanel == null || this.treeTable == null) {
            return null;
        }
        if (bl) {
            return UIUtils.createScreenshot(this.treeTablePanel.getScrollPane());
        }
        return UIUtils.createScreenshot(this.treeTable);
    }

    public void setDataToDisplay(CPUResultsSnapshot cPUResultsSnapshot, PrestimeCPUCCTNode prestimeCPUCCTNode, int n) {
        super.setDataToDisplay(cPUResultsSnapshot, n);
        this.rootNode = ((PrestimeCPUCCTNodeBacked)prestimeCPUCCTNode).createRootCopy();
        if (this.popupShowSource != null) {
            this.popupShowSource.setEnabled(this.isShowSourceAvailable());
        }
    }

    public void setDefaultSorting() {
        this.setSorting(1, false);
    }

    @Override
    public String getDefaultViewName() {
        return "cpu-subtree";
    }

    public void setFindString(String string) {
        this.treeTable.setFindParameters(string, 0);
    }

    public String getFindString() {
        return this.treeTable.getFindString();
    }

    public boolean isFindStringDefined() {
        return this.treeTable.isFindStringDefined();
    }

    @Override
    public String getSelectedMethodName() {
        int n = this.rootNode.getMethodId();
        String string = this.snapshot.getInstrMethodClasses(this.currentView)[n];
        if (this.currentView == 0) {
            string = string + "." + this.snapshot.getInstrMethodNames()[n] + this.snapshot.getInstrMethodSignatures()[n];
        }
        return string;
    }

    public String getSelectedMethodNameShort() {
        int n = this.rootNode.getMethodId();
        if (this.currentView == 0) {
            return this.snapshot.getInstrMethodNames()[n];
        }
        return this.snapshot.getInstrMethodClasses(this.currentView)[n];
    }

    public String getSelectedThreadName() {
        int n = this.rootNode.getThreadId();
        return this.snapshot.getThreadNameForId(n);
    }

    public String getShortTitle() {
        return MessageFormat.format(PANEL_TITLE_SHORT, this.getSelectedThreadName(), this.getSelectedMethodNameShort());
    }

    public void setSorting(int n, boolean bl) {
        if (n == -1) {
            this.setDefaultSorting();
        } else {
            this.sortingColumn = n;
            this.sortOrder = bl;
        }
    }

    @Override
    public int getSortingColumn() {
        return this.sortingColumn;
    }

    @Override
    public boolean getSortingOrder() {
        return this.sortOrder;
    }

    public String getTitle() {
        return MessageFormat.format(PANEL_TITLE, this.getSelectedThreadName(), this.getSelectedMethodName());
    }

    public boolean findFirst() {
        return this.treeTable.findFirst();
    }

    public boolean findNext() {
        return this.treeTable.findNext();
    }

    public boolean findPrevious() {
        return this.treeTable.findPrevious();
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.treeTablePanel.getScrollPane().getVerticalScrollBar().isEnabled();
    }

    @Override
    public void prepareResults() {
        this.initColumnsData();
        this.abstractTreeTableModel = new AbstractTreeTableModel((CCTNode)this.rootNode, this.sortingColumn, this.sortOrder){

            @Override
            public int getColumnCount() {
                return SubtreeCallGraphPanel.this.columnCount;
            }

            @Override
            public String getColumnName(int n) {
                return SubtreeCallGraphPanel.this.columnNames[n];
            }

            @Override
            public Class getColumnClass(int n) {
                if (n == 0) {
                    return TreeTableModel.class;
                }
                return Object.class;
            }

            @Override
            public Object getValueAt(Object object, int n) {
                if (!SubtreeCallGraphPanel.this.snapshot.isCollectingTwoTimeStamps() && n > 2) {
                    ++n;
                }
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)object;
                switch (n) {
                    case 0: {
                        return this.getNodeName(prestimeCPUCCTNode);
                    }
                    case 1: {
                        return this.getNodeTimeRel(prestimeCPUCCTNode);
                    }
                    case 2: {
                        return this.getNodeTime(prestimeCPUCCTNode);
                    }
                    case 3: {
                        return this.getNodeSecondaryTime(prestimeCPUCCTNode);
                    }
                    case 4: {
                        return this.getNodeInvocations(prestimeCPUCCTNode);
                    }
                }
                return null;
            }

            @Override
            public String getColumnToolTipText(int n) {
                return SubtreeCallGraphPanel.this.columnToolTips[n];
            }

            private String getNodeName(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return prestimeCPUCCTNode.toString();
            }

            private Float getNodeTimeRel(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return new Float(prestimeCPUCCTNode.getTotalTime0InPerCent());
            }

            private String getNodeTime(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return StringUtils.mcsTimeToString((long)prestimeCPUCCTNode.getTotalTime0()) + " ms (" + SubtreeCallGraphPanel.this.percentFormat.format(prestimeCPUCCTNode.getTotalTime0InPerCent() / 100.0f) + ")";
            }

            private String getNodeSecondaryTime(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return StringUtils.mcsTimeToString((long)prestimeCPUCCTNode.getTotalTime1()) + " ms";
            }

            private Integer getNodeInvocations(PrestimeCPUCCTNode prestimeCPUCCTNode) {
                return prestimeCPUCCTNode.getNCalls();
            }

            @Override
            public void sortByColumn(int n, boolean bl) {
                SubtreeCallGraphPanel.this.sortOrder = bl;
                if (!SubtreeCallGraphPanel.this.snapshot.isCollectingTwoTimeStamps() && n > 2) {
                    ++n;
                }
                PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)this.root;
                switch (n) {
                    case 0: {
                        prestimeCPUCCTNode.sortChildren(1, bl);
                        break;
                    }
                    case 1: {
                        prestimeCPUCCTNode.sortChildren(2, bl);
                        break;
                    }
                    case 2: {
                        prestimeCPUCCTNode.sortChildren(2, bl);
                        break;
                    }
                    case 3: {
                        prestimeCPUCCTNode.sortChildren(3, bl);
                        break;
                    }
                    case 4: {
                        prestimeCPUCCTNode.sortChildren(4, bl);
                    }
                }
            }

            @Override
            public boolean getInitialSorting(int n) {
                return n == 0;
            }
        };
        this.treeTableModel = new ExtendedTreeTableModel(this.abstractTreeTableModel);
        if (this.columnsVisibility != null) {
            this.treeTableModel.setColumnsVisibility(this.columnsVisibility);
        }
        this.treeTable = new JTreeTable(this.treeTableModel){

            @Override
            public void doLayout() {
                int n = 0;
                int n2 = -1;
                TableColumnModel tableColumnModel = this.getColumnModel();
                for (int i = 0; i < SubtreeCallGraphPanel.this.treeTableModel.getColumnCount(); ++i) {
                    int n3 = SubtreeCallGraphPanel.this.treeTableModel.getRealColumn(i);
                    if (n3 == 0) {
                        n2 = i;
                        continue;
                    }
                    n += tableColumnModel.getColumn(i).getPreferredWidth();
                }
                if (n2 != -1) {
                    tableColumnModel.getColumn(n2).setPreferredWidth(Math.max(this.getWidth() - n, SubtreeCallGraphPanel.this.minNamesColumnWidth));
                }
                super.doLayout();
            }
        };
        this.treeTable.getAccessibleContext().setAccessibleName(TREETABLE_ACCESS_NAME);
        this.treeTable.setRowSelectionAllowed(true);
        this.treeTable.setSelectionMode(0);
        this.treeTable.setGridColor(UIConstants.TABLE_VERTICAL_GRID_COLOR);
        this.treeTable.setSelectionBackground(UIConstants.TABLE_SELECTION_BACKGROUND_COLOR);
        this.treeTable.setSelectionForeground(UIConstants.TABLE_SELECTION_FOREGROUND_COLOR);
        this.treeTable.setShowHorizontalLines(false);
        this.treeTable.setShowVerticalLines(true);
        this.treeTable.setRowMargin(0);
        this.treeTable.setRowHeight(UIUtils.getDefaultRowHeight() + 2);
        this.treeTable.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "DEFAULT_ACTION");
        this.treeTable.getActionMap().put("DEFAULT_ACTION", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SubtreeCallGraphPanel.this.performDefaultAction();
            }
        });
        HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(0));
        hashSet.add(KeyStroke.getKeyStroke(9, 0));
        this.treeTable.setFocusTraversalKeys(0, hashSet);
        hashSet = new HashSet<AWTKeyStroke>(this.treeTable.getFocusTraversalKeys(1));
        hashSet.add(KeyStroke.getKeyStroke(9, 1));
        this.treeTable.setFocusTraversalKeys(1, hashSet);
        this.setColumnsData();
        UIUtils.autoExpandRoot(this.treeTable.getTree(), 2);
        UIUtils.makeTreeAutoExpandable(this.treeTable.getTree(), 2);
        this.treeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                int n;
                if ((keyEvent.getKeyCode() == 525 || keyEvent.getKeyCode() == 121 && keyEvent.getModifiers() == 1) && (n = SubtreeCallGraphPanel.this.treeTable.getSelectedRow()) != -1) {
                    SubtreeCallGraphPanel.this.popupPath = SubtreeCallGraphPanel.this.treeTable.getTree().getPathForRow(n);
                    PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)SubtreeCallGraphPanel.this.popupPath.getLastPathComponent();
                    SubtreeCallGraphPanel.this.enableDisablePopup(prestimeCPUCCTNode);
                    Rectangle rectangle = SubtreeCallGraphPanel.this.treeTable.getCellRect(n, 0, false);
                    SubtreeCallGraphPanel.this.callGraphPopupMenu.show(keyEvent.getComponent(), rectangle.x + SubtreeCallGraphPanel.this.treeTable.getSize().width > 50 ? 50 : 5, rectangle.y);
                }
            }
        });
        this.treeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getModifiers() == 4) {
                    SubtreeCallGraphPanel.this.popupPath = SubtreeCallGraphPanel.this.treeTable.getTree().getPathForRow(SubtreeCallGraphPanel.this.treeTable.rowAtPoint(mouseEvent.getPoint()));
                    if (SubtreeCallGraphPanel.this.popupPath != null) {
                        SubtreeCallGraphPanel.this.treeTable.getTree().setSelectionPath(SubtreeCallGraphPanel.this.popupPath);
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                SubtreeCallGraphPanel.this.popupPath = SubtreeCallGraphPanel.this.treeTable.getTree().getPathForRow(SubtreeCallGraphPanel.this.treeTable.rowAtPoint(mouseEvent.getPoint()));
                if (SubtreeCallGraphPanel.this.popupPath == null) {
                    if (mouseEvent.getModifiers() == 4) {
                        SubtreeCallGraphPanel.this.treeTable.getTree().clearSelection();
                    }
                } else {
                    SubtreeCallGraphPanel.this.treeTable.getTree().setSelectionPath(SubtreeCallGraphPanel.this.popupPath);
                    if (mouseEvent.getModifiers() == 4) {
                        PrestimeCPUCCTNode prestimeCPUCCTNode = (PrestimeCPUCCTNode)SubtreeCallGraphPanel.this.popupPath.getLastPathComponent();
                        SubtreeCallGraphPanel.this.enableDisablePopup(prestimeCPUCCTNode);
                        SubtreeCallGraphPanel.this.callGraphPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    } else if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2 && SubtreeCallGraphPanel.this.treeTableModel.isLeaf(SubtreeCallGraphPanel.this.popupPath.getPath()[SubtreeCallGraphPanel.this.popupPath.getPath().length - 1])) {
                        SubtreeCallGraphPanel.this.showSourceForMethod(SubtreeCallGraphPanel.this.popupPath);
                    }
                }
            }
        });
        this.treeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = SubtreeCallGraphPanel.this.treeTable.getSelectedRow();
                if (n == -1) {
                    return;
                }
                SubtreeCallGraphPanel.this.popupPath = SubtreeCallGraphPanel.this.treeTable.getTree().getPathForRow(n);
            }
        });
        this.treeTablePanel = new JTreeTablePanel(this.treeTable);
        this.treeTablePanel.setCorner("UPPER_RIGHT_CORNER", this.cornerButton);
        this.treeTablePanel.clearBorders();
        this.add((Component)this.treeTablePanel, "Center");
        this.initFilterPanel();
        this.initFirstColumnName();
    }

    private void initFilterPanel() {
        this.filterComponent = FilterComponent.create(true, true);
        FilterSortSupport.Configuration configuration = this.snapshot.getFilterSortInfo((CCTNode)((PrestimeCPUCCTNode)this.treeTableModel.getRoot()));
        this.filterComponent.setFilter(configuration.getFilterString(), configuration.getFilterType());
        this.filterComponent.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                String string = SubtreeCallGraphPanel.this.filterComponent.getFilterValue();
                int n = SubtreeCallGraphPanel.this.filterComponent.getFilterType();
                SubtreeCallGraphPanel.this.snapshot.filterForward(string, n, (PrestimeCPUCCTNodeBacked)SubtreeCallGraphPanel.this.treeTableModel.getRoot());
                SubtreeCallGraphPanel.this.treeTable.updateTreeTable();
            }
        });
        this.add((Component)this.filterComponent.getComponent(), "South");
    }

    @Override
    public void requestFocus() {
        if (this.treeTable != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SubtreeCallGraphPanel.this.treeTable.requestFocus();
                }
            });
        }
    }

    @Override
    public void reset() {
        if (this.treeTablePanel != null) {
            this.remove(this.treeTablePanel);
            this.treeTablePanel = null;
            this.remove(this.filterComponent.getComponent());
            this.filterComponent = null;
        }
        this.treeTable = null;
        this.abstractTreeTableModel = null;
        this.treeTableModel = null;
    }

    @Override
    protected boolean isCloseable() {
        return true;
    }

    @Override
    protected void initColumnSelectorItems() {
        this.cornerPopup.removeAll();
        for (int i = 0; i < this.columnCount; ++i) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(this.columnNames[i]);
            jCheckBoxMenuItem.setActionCommand(Integer.valueOf(i).toString());
            this.addMenuItemListener(jCheckBoxMenuItem);
            if (this.treeTable != null) {
                jCheckBoxMenuItem.setState(this.treeTableModel.isRealColumnVisible(i));
                if (i == 0) {
                    jCheckBoxMenuItem.setEnabled(false);
                }
            } else {
                jCheckBoxMenuItem.setState(true);
            }
            this.cornerPopup.add(jCheckBoxMenuItem);
        }
        this.cornerPopup.addSeparator();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(FILTER_ITEM_NAME);
        jCheckBoxMenuItem.setActionCommand("Filter");
        this.addMenuItemListener(jCheckBoxMenuItem);
        if (this.filterComponent == null) {
            jCheckBoxMenuItem.setState(true);
        } else {
            jCheckBoxMenuItem.setState(this.filterComponent.getComponent().isVisible());
        }
        this.cornerPopup.add(jCheckBoxMenuItem);
        this.cornerPopup.pack();
    }

    private void setColumnsData() {
        TableColumnModel tableColumnModel = this.treeTable.getColumnModel();
        this.treeTable.setTreeCellRenderer(this.enhancedTreeCellRenderer);
        tableColumnModel.getColumn(0).setPreferredWidth(this.minNamesColumnWidth);
        for (int i = 0; i < this.treeTableModel.getColumnCount(); ++i) {
            int n = this.treeTableModel.getRealColumn(i);
            if (n == 0) continue;
            tableColumnModel.getColumn(i).setPreferredWidth(this.columnWidths[n - 1]);
            tableColumnModel.getColumn(i).setCellRenderer(this.columnRenderers[n]);
        }
    }

    private void addMenuItemListener(JCheckBoxMenuItem jCheckBoxMenuItem) {
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Filter")) {
                    SubtreeCallGraphPanel.this.filterComponent.getComponent().setVisible(!SubtreeCallGraphPanel.this.filterComponent.getComponent().isVisible());
                    return;
                }
                boolean bl = false;
                int n = Integer.parseInt(actionEvent.getActionCommand());
                boolean bl2 = SubtreeCallGraphPanel.this.treeTable.getSortingOrder();
                int n2 = SubtreeCallGraphPanel.this.treeTable.getSortingColumn();
                int n3 = SubtreeCallGraphPanel.this.treeTableModel.getRealColumn(n2);
                boolean bl3 = SubtreeCallGraphPanel.this.treeTableModel.isRealColumnVisible(n);
                if (bl3 && n == n3) {
                    n2 = n2 + 1 == SubtreeCallGraphPanel.this.treeTableModel.getColumnCount() ? n2 - 1 : n2 + 1;
                    n3 = SubtreeCallGraphPanel.this.treeTableModel.getRealColumn(n2);
                    bl = true;
                }
                SubtreeCallGraphPanel.this.treeTableModel.setRealColumnVisibility(n, !bl3);
                SubtreeCallGraphPanel.this.treeTable.createDefaultColumnsFromModel();
                SubtreeCallGraphPanel.this.treeTable.updateTreeTableHeader();
                n2 = SubtreeCallGraphPanel.this.treeTableModel.getVirtualColumn(n3);
                if (bl) {
                    bl2 = SubtreeCallGraphPanel.this.treeTableModel.getInitialSorting(n2);
                    SubtreeCallGraphPanel.this.treeTableModel.sortByColumn(n2, bl2);
                    SubtreeCallGraphPanel.this.treeTable.updateTreeTable();
                }
                SubtreeCallGraphPanel.this.treeTable.setSortingColumn(n2);
                SubtreeCallGraphPanel.this.treeTable.setSortingOrder(bl2);
                SubtreeCallGraphPanel.this.treeTable.getTableHeader().repaint();
                SubtreeCallGraphPanel.this.setColumnsData();
            }
        });
    }

    private void enableDisablePopup(PrestimeCPUCCTNode prestimeCPUCCTNode) {
        boolean bl;
        boolean bl2 = bl = prestimeCPUCCTNode.getThreadId() != -1 && prestimeCPUCCTNode.getMethodId() != 0 && !prestimeCPUCCTNode.isFilteredNode();
        if (this.popupShowSource != null) {
            this.popupShowSource.setEnabled(bl && this.isShowSourceAvailable());
        }
        if (this.popupShowSubtree != null) {
            this.popupShowSubtree.setEnabled(bl);
        }
        if (this.popupShowReverse != null) {
            this.popupShowReverse.setEnabled(bl);
        }
        this.popupFind.setEnabled(bl);
    }

    private void initColumnsData() {
        int n;
        this.columnCount = this.snapshot.isCollectingTwoTimeStamps() ? 5 : 4;
        this.columnWidths = new int[this.columnCount - 1];
        this.columnNames = new String[this.columnCount];
        this.columnRenderers = new TableCellRenderer[this.columnCount];
        this.columnsVisibility = new boolean[this.columnCount];
        for (n = 0; n < this.columnCount - 1; ++n) {
            this.columnsVisibility[n] = true;
        }
        if (this.isSampling() != null && !this.isSampling().booleanValue()) {
            this.columnsVisibility[this.columnCount - 1] = true;
        }
        if (this.columnCount == 5) {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, TIME_REL_COLUMN_NAME, TIME_COLUMN_NAME, TIME_CPU_COLUMN_NAME, INVOCATIONS_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, TIME_REL_COLUMN_TOOLTIP, TIME_COLUMN_TOOLTIP, TIME_CPU_COLUMN_TOOLTIP, INVOCATIONS_COLUMN_TOOLTIP};
        } else {
            this.columnNames = new String[]{METHOD_COLUMN_NAME, TIME_REL_COLUMN_NAME, TIME_COLUMN_NAME, INVOCATIONS_COLUMN_NAME};
            this.columnToolTips = new String[]{METHOD_COLUMN_TOOLTIP, TIME_REL_COLUMN_TOOLTIP, TIME_COLUMN_TOOLTIP, INVOCATIONS_COLUMN_TOOLTIP};
        }
        if (this.isSampling() != null && this.isSampling().booleanValue()) {
            this.columnNames[this.columnCount - 1] = SAMPLES_COLUMN_NAME;
            this.columnToolTips[this.columnCount - 1] = SAMPLES_COLUMN_TOOLTIP;
        }
        n = this.getFontMetrics(this.getFont()).charWidth('W') * 12;
        CustomBarCellRenderer customBarCellRenderer = new CustomBarCellRenderer(0L, 100L);
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        LabelBracketTableCellRenderer labelBracketTableCellRenderer = new LabelBracketTableCellRenderer(11);
        this.columnRenderers[0] = null;
        this.columnWidths[0] = n;
        this.columnRenderers[1] = customBarCellRenderer;
        this.columnWidths[1] = n;
        this.columnRenderers[2] = labelBracketTableCellRenderer;
        for (int i = 3; i < this.columnCount; ++i) {
            this.columnWidths[i - 1] = n;
            this.columnRenderers[i] = labelTableCellRenderer;
        }
        if (this.isSampling() == null) {
            --this.columnCount;
        }
    }

    private void initFirstColumnName() {
        switch (this.currentView) {
            case 0: {
                this.columnNames[0] = METHOD_COLUMN_NAME;
                this.columnToolTips[0] = METHOD_COLUMN_TOOLTIP;
                this.filterComponent.setHint(METHOD_FILTER_HINT);
                break;
            }
            case 1: {
                this.columnNames[0] = CLASS_COLUMN_NAME;
                this.columnToolTips[0] = CLASS_COLUMN_TOOLTIP;
                this.filterComponent.setHint(CLASS_FILTER_HINT);
                break;
            }
            case 2: {
                this.columnNames[0] = PACKAGE_COLUMN_NAME;
                this.columnToolTips[0] = PACKAGE_COLUMN_TOOLTIP;
                this.filterComponent.setHint(PACKAGE_FILTER_HINT);
            }
        }
    }
}

