/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileProvider;
import org.netbeans.lib.profiler.ui.LiveResultsPanel;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;

public class LiveFlatProfileCollectorPanel
extends FlatProfilePanel
implements LiveResultsPanel {
    private JPopupMenu popup;
    private TargetAppRunner runner = null;
    private boolean firstTime = true;
    private boolean updateResultsInProgress = false;
    private boolean updateResultsPending = false;

    public LiveFlatProfileCollectorPanel(TargetAppRunner targetAppRunner, CPUResUserActionsHandler cPUResUserActionsHandler, CPUSelectionHandler cPUSelectionHandler, boolean bl) {
        super(cPUResUserActionsHandler, cPUSelectionHandler, bl);
        this.runner = targetAppRunner;
        this.addFilterListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (LiveFlatProfileCollectorPanel.this.flatProfileContainer != null) {
                    LiveFlatProfileCollectorPanel.this.setDataToDisplay(LiveFlatProfileCollectorPanel.this.flatProfileContainer);
                }
            }
        });
        this.initComponents();
    }

    public void setDataToDisplay(FlatProfileContainer flatProfileContainer) {
        this.threadId = -1;
        this.flatProfileContainer = flatProfileContainer;
        this.collectingTwoTimeStamps = this.flatProfileContainer.isCollectingTwoTimeStamps();
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterValues(this.filterString), this.filterType, this.valueFilterValue);
        this.prepareResults(this.firstTime);
        this.firstTime = false;
        this.setResultsAvailable(this.hasData());
    }

    @Override
    public BufferedImage getViewImage(boolean bl) {
        if (bl) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    @Override
    public String getViewName() {
        return "cpu-live";
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    @Override
    public void handleRemove() {
    }

    @Override
    public void handleShutdown() {
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = false;
            this.popup.setVisible(false);
        }
    }

    public boolean hasData() {
        return this.flatProfileContainer != null && this.flatProfileContainer.getNRows() > 0;
    }

    @Override
    public boolean hasView() {
        return this.resTable != null;
    }

    @Override
    public void prepareResults() {
        super.prepareResults();
    }

    @Override
    public boolean supports(int n) {
        return n == 3 || n == 4 || n == 2;
    }

    @Override
    public void updateLiveResults() {
        FlatProfileProvider flatProfileProvider;
        if (this.popup != null && this.popup.isVisible()) {
            this.updateResultsPending = true;
            return;
        }
        if (this.updateResultsInProgress) {
            return;
        }
        this.updateResultsInProgress = true;
        String string = null;
        if (this.resTable != null) {
            int n = this.resTable.getSelectedRow();
            if (n >= this.resTable.getRowCount()) {
                n = -1;
                this.resTable.clearSelection();
            }
            if (n != -1) {
                string = this.resTable.getValueAt(n, 0).toString();
            }
        }
        if ((flatProfileProvider = this.getFlatProfileProvider()) != null) {
            FlatProfileContainer flatProfileContainer = flatProfileProvider.createFlatProfile();
            int n = 2;
            boolean bl = false;
            do {
                bl = false;
                if (flatProfileContainer != null) {
                    this.setDataToDisplay(flatProfileContainer);
                    if (string != null) {
                        this.resTable.selectRowByContents(string, 0, false);
                    }
                } else {
                    bl = true;
                }
                if (!bl) continue;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    bl = false;
                }
            } while (--n > 0 && bl);
        }
        this.updateResultsInProgress = false;
    }

    public FlatProfileProvider getFlatProfileProvider() {
        return this.runner.getProfilerClient().getFlatProfileProvider();
    }

    @Override
    protected String[] getMethodClassNameAndSig(int n, int n2) {
        ProfilingSessionStatus profilingSessionStatus = this.runner.getProfilingSessionStatus();
        String string = profilingSessionStatus.getInstrMethodClasses()[n];
        if (n2 == 0) {
            String string2 = profilingSessionStatus.getInstrMethodNames() != null ? profilingSessionStatus.getInstrMethodNames()[n] : null;
            String string3 = profilingSessionStatus.getInstrMethodSignatures() != null ? profilingSessionStatus.getInstrMethodSignatures()[n] : null;
            return new String[]{string, string2, string3};
        }
        return new String[]{string, null, null};
    }

    @Override
    protected JPopupMenu createPopupMenu() {
        if (this.popup == null) {
            this.popup = super.createPopupMenu();
        }
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (LiveFlatProfileCollectorPanel.this.updateResultsPending) {
                            LiveFlatProfileCollectorPanel.this.updateLiveResults();
                            LiveFlatProfileCollectorPanel.this.updateResultsPending = false;
                        }
                    }
                });
            }
        });
        return this.popup;
    }

    @Override
    protected void obtainResults() {
        if (!this.collectingTwoTimeStamps && this.sortBy == 3) {
            this.sortBy = 2;
        }
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterValues(this.filterString), this.filterType, this.valueFilterValue);
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
    }

    @Override
    protected void showReverseCallGraph(int n, int n2, int n3, int n4, boolean bl) {
        throw new IllegalStateException();
    }

    @Override
    protected boolean supportsReverseCallGraph() {
        return false;
    }

    @Override
    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    void setSelectedRowString(String string) {
        if (string != null) {
            this.resTable.selectRowByContents(string, 0, false);
        }
    }

    String getSelectedRowString() {
        String string = null;
        if (this.resTable != null) {
            int n = this.resTable.getSelectedRow();
            if (n >= this.resTable.getRowCount()) {
                n = -1;
                this.resTable.clearSelection();
            }
            if (n != -1) {
                string = this.resTable.getValueAt(n, 0).toString();
            }
        }
        return string;
    }

    private void initComponents() {
        this.setPreferredSize(new Dimension(800, 600));
    }

    public void exportData(int n, ExportDataDumper exportDataDumper, String string) {
        this.percentFormat.setMaximumFractionDigits(2);
        this.percentFormat.setMinimumFractionDigits(2);
        switch (n) {
            case 1: {
                this.exportCSV(",", exportDataDumper);
                break;
            }
            case 2: {
                this.exportCSV(";", exportDataDumper);
                break;
            }
            case 3: {
                this.exportXML(exportDataDumper, string);
                break;
            }
            case 4: {
                this.exportHTML(exportDataDumper, string);
            }
        }
        this.percentFormat.setMaximumFractionDigits(1);
        this.percentFormat.setMinimumFractionDigits(0);
    }

    private void exportHTML(ExportDataDumper exportDataDumper, String string) {
        int n;
        StringBuffer stringBuffer = new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + string + "</TITLE></HEAD><BODY><TABLE border=\"1\"><tr>");
        for (n = 0; n < this.columnCount; ++n) {
            stringBuffer.append("<th>").append(this.columnNames[n]).append("</th>");
        }
        stringBuffer.append("</tr>");
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        for (n = 0; n < this.flatProfileContainer.getNRows(); ++n) {
            stringBuffer = new StringBuffer("<tr><td>" + this.replaceHTMLCharacters(this.flatProfileContainer.getMethodNameAtRow(n)) + "</td>");
            stringBuffer.append("<td align=\"right\">").append(this.percentFormat.format(this.flatProfileContainer.getPercentAtRow(n) / 100.0f)).append(this.flatProfileContainer.getTimeInMcs0AtRow(n) % 10L == 0L ? (this.flatProfileContainer.getTimeInMcs0AtRow(n) % 100L == 0L ? (this.flatProfileContainer.getTimeInMcs0AtRow(n) % 1000L == 0L ? "    " : "  ") : " ") : "").append("</td>");
            stringBuffer.append("<td align=right>").append((double)this.flatProfileContainer.getTimeInMcs0AtRow(n) / 1000.0).append(" ms</td>");
            if (this.collectingTwoTimeStamps) {
                stringBuffer.append("<td align=right>").append((double)this.flatProfileContainer.getTimeInMcs1AtRow(n) / 1000.0).append(" ms</td>");
            }
            stringBuffer.append("<td align=right>").append((double)this.flatProfileContainer.getTotalTimeInMcs0AtRow(n) / 1000.0).append(" ms</td>");
            if (this.collectingTwoTimeStamps) {
                stringBuffer.append("<td align=right>").append((double)this.flatProfileContainer.getTotalTimeInMcs1AtRow(n) / 1000.0).append(" ms</td>");
            }
            stringBuffer.append("<td align=\"right\">").append(this.flatProfileContainer.getNInvocationsAtRow(n)).append("</td></tr>");
            exportDataDumper.dumpData((CharSequence)stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper exportDataDumper, String string) {
        int n;
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string2 + "<ExportedView Name=\"" + string + "\" type=\"table\">" + string2 + " <TableData NumRows=\"" + this.flatProfileContainer.getNRows() + "\" NumColumns=\"4\">" + string2 + "  <TableHeader>");
        for (n = 0; n < this.columnCount; ++n) {
            stringBuffer.append("   <TableColumn><![CDATA[").append(this.columnNames[n]).append("]]></TableColumn>").append(string2);
        }
        stringBuffer.append("  </TableHeader>").append(string2).append("  <TableBody>").append(string2);
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        for (n = 0; n < this.flatProfileContainer.getNRows(); ++n) {
            stringBuffer = new StringBuffer("   <TableRow>" + string2 + "    <TableColumn><![CDATA[" + this.flatProfileContainer.getMethodNameAtRow(n) + "]]></TableColumn>" + string2);
            stringBuffer.append("    <TableColumn><![CDATA[").append(this.percentFormat.format(this.flatProfileContainer.getPercentAtRow(n) / 100.0f)).append("]]></TableColumn>").append(string2);
            stringBuffer.append("    <TableColumn><![CDATA[").append((double)this.flatProfileContainer.getTimeInMcs0AtRow(n) / 1000.0).append(" ms]]></TableColumn>").append(string2);
            if (this.collectingTwoTimeStamps) {
                stringBuffer.append("    <TableColumn><![CDATA[").append((double)this.flatProfileContainer.getTimeInMcs1AtRow(n) / 1000.0).append(" ms]]></TableColumn>").append(string2);
            }
            stringBuffer.append("    <TableColumn><![CDATA[").append((double)this.flatProfileContainer.getTotalTimeInMcs0AtRow(n) / 1000.0).append(" ms]]></TableColumn>").append(string2);
            if (this.collectingTwoTimeStamps) {
                stringBuffer.append("    <TableColumn><![CDATA[").append((double)this.flatProfileContainer.getTotalTimeInMcs1AtRow(n) / 1000.0).append(" ms]]></TableColumn>").append(string2);
            }
            stringBuffer.append("    <TableColumn><![CDATA[").append(this.flatProfileContainer.getNInvocationsAtRow(n)).append("]]></TableColumn>").append(string2).append("  </TableRow>").append(string2);
            exportDataDumper.dumpData((CharSequence)stringBuffer);
        }
        exportDataDumper.dumpDataAndClose(new StringBuffer("  </TableBody> </TableData>" + string2 + "</ExportedView>"));
    }

    private void exportCSV(String string, ExportDataDumper exportDataDumper) {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = "\r\n";
        String string3 = "\"";
        for (n = 0; n < this.columnCount; ++n) {
            stringBuffer.append(string3).append(this.columnNames[n]).append(string3).append(string);
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        stringBuffer.append(string2);
        exportDataDumper.dumpData((CharSequence)stringBuffer);
        for (n = 0; n < this.flatProfileContainer.getNRows(); ++n) {
            stringBuffer = new StringBuffer();
            stringBuffer.append(string3).append(this.flatProfileContainer.getMethodNameAtRow(n)).append(string3).append(string);
            stringBuffer.append(string3).append(this.flatProfileContainer.getPercentAtRow(n)).append(string3).append(string);
            stringBuffer.append(string3).append((double)this.flatProfileContainer.getTimeInMcs0AtRow(n) / 1000.0).append(" ms").append(string3).append(string);
            if (this.collectingTwoTimeStamps) {
                stringBuffer.append(string3).append((double)this.flatProfileContainer.getTimeInMcs1AtRow(n) / 1000.0).append(" ms").append(string3).append(string);
            }
            stringBuffer.append(string3).append((double)this.flatProfileContainer.getTotalTimeInMcs0AtRow(n) / 1000.0).append(" ms").append(string3).append(string);
            if (this.collectingTwoTimeStamps) {
                stringBuffer.append(string3).append((double)this.flatProfileContainer.getTotalTimeInMcs1AtRow(n) / 1000.0).append(" ms").append(string3).append(string);
            }
            stringBuffer.append(string3).append(this.flatProfileContainer.getNInvocationsAtRow(n)).append(string3).append(string2);
            exportDataDumper.dumpData((CharSequence)stringBuffer);
        }
        exportDataDumper.close();
    }

    private String replaceHTMLCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }
}

