/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui.components.information;

import com.jrockit.mc.components.ui.components.ComponentDescriptor;
import com.jrockit.mc.components.ui.services.IServiceLocator;
import com.jrockit.mc.flightrecorder.spi.EventOrder;
import com.jrockit.mc.flightrecorder.spi.FieldType;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IValues;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.ViewModelBuilder;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.AggregatorFactory;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.IAggregator;
import com.jrockit.mc.flightrecorder.ui.components.aggregators.ISortedAggregator;
import com.jrockit.mc.flightrecorder.ui.components.information.InformationDescriptor;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public final class InformationModelBuilder<T extends InformationDescriptor>
extends ViewModelBuilder<Map<String, Object>> {
    private final List<T> m_informationDescriptors;
    private final boolean m_alwaysUseDerivative;

    public InformationModelBuilder(IServiceLocator serviceLocator, List<T> descriptors, ComponentDescriptor cd, boolean alwaysUseDerivative) {
        super(serviceLocator, cd.getName());
        this.m_informationDescriptors = descriptors;
        this.m_alwaysUseDerivative = alwaysUseDerivative;
    }

    @Override
    protected Map<String, Object> buildModel(IView view, IProgressMonitor monitor) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        int n = 0;
        while (n < this.m_informationDescriptors.size()) {
            if (!monitor.isCanceled()) {
                result.put(Integer.toString(n), this.calculateValue((InformationDescriptor)this.m_informationDescriptors.get(n), view));
            } else {
                result.put(Integer.toString(n), null);
            }
            ++n;
        }
        return result;
    }

    private Object calculateValue(T attributeDescriptor, IView eventView) {
        IValues values = eventView.getValues();
        values.setAttribute(Arrays.asList(((InformationDescriptor)attributeDescriptor).getAttributeIdentifier()));
        values.setFieldTypes(Arrays.asList(FieldType.NUMERIC, FieldType.OBJECT, FieldType.STRING));
        IAggregator aggregator = AggregatorFactory.createAggregator(((InformationDescriptor)attributeDescriptor).getAggregatorIdentifier());
        if (ISortedAggregator.class.isAssignableFrom(aggregator.getClass())) {
            eventView.setOrder(EventOrder.ASCENDING);
        }
        for (Object o : values) {
            aggregator.add(o);
        }
        if (this.m_alwaysUseDerivative || ((InformationDescriptor)attributeDescriptor).getUnit().getDerivative()) {
            return this.calculteDerivative(aggregator.getResult(), eventView.getRange());
        }
        return aggregator.getResult();
    }

    private Number calculteDerivative(Object value, ITimeRange range) {
        if (value instanceof Number) {
            double numberValue = ((Number)value).doubleValue();
            double durationInSeconds = (double)range.getDuration() / 1.0E9;
            if (durationInSeconds > 0.0) {
                return numberValue / durationInSeconds;
            }
        }
        return null;
    }
}

